# DonyayeGame Authentication Plugin

A WordPress plugin that provides mobile OTP authentication for DonyayeGame users with SMS.ir integration.

## Features

- **Mobile OTP Authentication**: Users can login using their mobile number and OTP code
- **Automatic User Registration**: New users are automatically registered with customer role
- **SMS.ir Integration**: Sends OTP codes via SMS.ir API
- **Multi-step Forms**: Clean, user-friendly authentication flow
- **Responsive Design**: Mobile-first responsive design
- **Security Features**: Nonce verification, input sanitization, and validation
- **Custom User Meta**: Stores mobile number, national code, and birth date
- **Shortcodes**: Easy integration with any page or post

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- MySQL 5.6 or higher
- SMS.ir account with API access

## Installation

1. **Upload Plugin Files**:
   - Upload the `donyaye-game-auth` folder to your `/wp-content/plugins/` directory
   - Or zip the folder and upload via WordPress admin panel

2. **Activate Plugin**:
   - Go to WordPress Admin → Plugins
   - Find "DonyayeGame Authentication" and click "Activate"

3. **Configure SMS Settings**:
   - Go to WordPress Admin → Settings → DonyayeGame Auth
   - Enter your SMS.ir API credentials:
     - API Key
     - Secret Key
     - Template ID
     - OTP Expiry time (in seconds)

## Configuration

### SMS.ir Setup

1. **Get API Credentials**:
   - Log in to your SMS.ir account
   - Go to API section
   - Generate API Key and Secret Key

2. **Create SMS Template**:
   - Create a verification template in SMS.ir
   - Use parameter `{Code}` for OTP code
   - Note the Template ID

3. **Plugin Settings**:
   ```
   API Key: Your SMS.ir API Key
   Secret Key: Your SMS.ir Secret Key
   Template ID: Your verification template ID
   OTP Expiry: 300 (5 minutes recommended)
   ```

## Usage

### Shortcodes

#### Login Form
```
[dga_login_form]
```

#### Registration Form
```
[dga_register_form]
```

#### User Profile
```
[dga_user_profile]
```

### Custom Attributes

#### Login Form
```
[dga_login_form redirect="/dashboard" class="custom-login-class"]
```

#### Registration Form
```
[dga_register_form class="custom-register-class"]
```

### Page Integration

1. **Create Login Page**:
   - Create a new page
   - Add shortcode: `[dga_login_form]`
   - Publish the page

2. **Create Registration Page**:
   - Create a new page
   - Add shortcode: `[dga_register_form]`
   - Publish the page

3. **Add to Navigation**:
   - Go to Appearance → Menus
   - Add your login/register pages to the menu

## How It Works

### Authentication Flow

1. **Step 1: Mobile Input**
   - User enters mobile number
   - System validates format (09xxxxxxxxx)
   - Sends OTP via SMS.ir

2. **Step 2: OTP Verification**
   - User enters 6-digit OTP code
   - System verifies OTP validity
   - Checks if user exists

3. **Step 3: User Decision**
   - If user exists: Logs in directly
   - If new user: Proceeds to registration

4. **Step 4: Registration (if needed)**
   - Collects: First Name, Last Name, National Code, Birth Date
   - Creates WordPress user with 'customer' role
   - Logs user in automatically

### Database Structure

The plugin creates a custom table for OTP management:

```sql
CREATE TABLE wp_dga_otp_codes (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    mobile varchar(15) NOT NULL,
    otp_code varchar(6) NOT NULL,
    created_at datetime DEFAULT CURRENT_TIMESTAMP,
    expires_at datetime NOT NULL,
    used tinyint(1) DEFAULT 0,
    PRIMARY KEY (id),
    KEY mobile (mobile),
    KEY otp_code (otp_code)
);
```

### User Meta Fields

- `mobile_number`: User's mobile number
- `national_code`: Iranian national code
- `birth_date`: Date of birth
- `registration_date`: Account creation date
- `last_login`: Last login timestamp

## Customization

### Styling

The plugin includes comprehensive CSS that can be customized:

1. **Override CSS**:
   - Add custom CSS to your theme
   - Target classes like `.dga-login-form`, `.dga-btn`, etc.

2. **Custom Classes**:
   - Use the `class` attribute in shortcodes
   - Apply your own styling

### JavaScript

The plugin includes JavaScript for form handling:

1. **Event Hooks**:
   - `dga_otp_sent`: Fired when OTP is sent
   - `dga_otp_verified`: Fired when OTP is verified
   - `dga_registration_completed`: Fired when registration is complete

2. **Custom Functions**:
   - Extend the JavaScript functionality
   - Add custom validation or behavior

## Security Features

- **Nonce Verification**: All AJAX requests use WordPress nonces
- **Input Sanitization**: All user inputs are properly sanitized
- **SQL Prepared Statements**: Database queries use prepared statements
- **Rate Limiting**: OTP expiry prevents abuse
- **Mobile Validation**: Iranian mobile number format validation
- **National Code Validation**: Algorithm-based national code verification

## Troubleshooting

### Common Issues

1. **OTP Not Sending**:
   - Check SMS.ir API credentials
   - Verify template ID
   - Check API quota/balance

2. **Forms Not Displaying**:
   - Ensure plugin is activated
   - Check for JavaScript errors
   - Verify shortcode syntax

3. **Database Errors**:
   - Check WordPress database permissions
   - Verify table creation on activation
   - Check for conflicting plugins

### Debug Mode

Enable WordPress debug mode to see detailed error messages:

```php
// In wp-config.php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

### Logs

Check WordPress debug log for detailed error information:
- Location: `/wp-content/debug.log`

## API Reference

### AJAX Actions

- `dga_send_otp`: Send OTP to mobile number
- `dga_verify_otp`: Verify OTP and authenticate user
- `dga_complete_registration`: Complete user registration
- `dga_get_user_info`: Get current user information
- `dga_logout`: Logout current user

### Hooks and Filters

- `dga_otp_expiry`: Filter OTP expiry time
- `dga_user_role`: Filter user role assignment
- `dga_mobile_validation`: Filter mobile number validation

## Support

For support and questions:

1. **Documentation**: Check this README file
2. **WordPress.org**: Search plugin support forums
3. **Developer**: Contact the plugin developer

## Changelog

### Version 1.0.0
- Initial release
- Mobile OTP authentication
- SMS.ir integration
- User registration system
- Responsive design
- Security features

## License

This plugin is licensed under the GPL v2 or later.

## Credits

- Developed for DonyayeGame
- SMS integration via SMS.ir
- Built with WordPress standards 