<?php
/**
 * Forms Handler Class
 */
class DGA_Forms {
    
    public function __construct() {
        add_shortcode('dga_login_form', array($this, 'login_form_shortcode'));
        add_shortcode('dga_register_form', array($this, 'register_form_shortcode'));
        add_shortcode('dga_user_profile', array($this, 'user_profile_shortcode'));
        add_action('wp_footer', array($this, 'add_modal_forms'));
    }
    
    /**
     * Login form shortcode
     */
    public function login_form_shortcode($atts) {
        if (is_user_logged_in()) {
            return $this->get_logged_in_user_info();
        }
        
        $atts = shortcode_atts(array(
            'redirect' => home_url('/dashboard'),
            'class' => 'dga-login-form'
        ), $atts);
        
        ob_start();
        ?>
        <div class="<?php echo esc_attr($atts['class']); ?>">
            <h3><?php _e('Login with Mobile OTP', 'donyaye-game'); ?></h3>
            
            <div class="dga-step dga-step-1 active">
                <form class="dga-mobile-form" method="post">
                    <div class="form-group">
                        <label for="mobile"><?php _e('Mobile Number:', 'donyaye-game'); ?></label>
                        <input type="tel" id="mobile" name="mobile" placeholder="09xxxxxxxxx" required>
                    </div>
                    
                    <button type="submit" class="dga-btn dga-btn-primary">
                        <?php _e('Send OTP', 'donyaye-game'); ?>
                    </button>
                </form>
            </div>
            
            <div class="dga-step dga-step-2" style="display: none;">
                <form class="dga-otp-form" method="post">
                    <input type="hidden" name="mobile" id="otp-mobile">
                    <input type="hidden" name="redirect" value="<?php echo esc_attr($atts['redirect']); ?>">
                    
                    <div class="form-group">
                        <label for="otp"><?php _e('Enter OTP Code:', 'donyaye-game'); ?></label>
                        <input type="text" id="otp" name="otp" placeholder="000000" maxlength="6" required>
                        <small class="dga-timer"><?php _e('Resend in:', 'donyaye-game'); ?> <span id="countdown">120</span>s</small>
                    </div>
                    
                    <button type="submit" class="dga-btn dga-btn-primary">
                        <?php _e('Verify & Login', 'donyaye-game'); ?>
                    </button>
                    
                    <button type="button" class="dga-btn dga-btn-secondary dga-back-btn">
                        <?php _e('Back', 'donyaye-game'); ?>
                    </button>
                </form>
            </div>
            
            <div class="dga-step dga-step-3" style="display: none;">
                <h4><?php _e('Complete Registration', 'donyaye-game'); ?></h4>
                <p><?php _e('Please provide your information to complete registration:', 'donyaye-game'); ?></p>
                
                <form class="dga-register-form" method="post">
                    <input type="hidden" name="mobile" id="reg-mobile">
                    <input type="hidden" name="redirect" value="<?php echo esc_attr($atts['redirect']); ?>">
                    
                    <div class="form-group">
                        <label for="first_name"><?php _e('First Name:', 'donyaye-game'); ?></label>
                        <input type="text" id="first_name" name="first_name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="last_name"><?php _e('Last Name:', 'donyaye-game'); ?></label>
                        <input type="text" id="last_name" name="last_name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="national_code"><?php _e('National Code:', 'donyaye-game'); ?></label>
                        <input type="text" id="national_code" name="national_code" maxlength="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="birth_date"><?php _e('Date of Birth:', 'donyaye-game'); ?></label>
                        <input type="date" id="birth_date" name="birth_date" required>
                    </div>
                    
                    <button type="submit" class="dga-btn dga-btn-primary">
                        <?php _e('Complete Registration', 'donyaye-game'); ?>
                    </button>
                </form>
            </div>
            
            <div class="dga-messages"></div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Registration form shortcode
     */
    public function register_form_shortcode($atts) {
        if (is_user_logged_in()) {
            return $this->get_logged_in_user_info();
        }
        
        $atts = shortcode_atts(array(
            'redirect' => home_url('/dashboard'),
            'class' => 'dga-register-form-standalone'
        ), $atts);
        
        ob_start();
        ?>
        <div class="<?php echo esc_attr($atts['class']); ?>">
            <h3><?php _e('Register New Account', 'donyaye-game'); ?></h3>
            
            <div class="dga-step dga-step-1 active">
                <form class="dga-mobile-form" method="post">
                    <div class="form-group">
                        <label for="mobile"><?php _e('Mobile Number:', 'donyaye-game'); ?></label>
                        <input type="tel" id="mobile" name="mobile" placeholder="09xxxxxxxxx" required>
                    </div>
                    
                    <button type="submit" class="dga-btn dga-btn-primary">
                        <?php _e('Send OTP', 'donyaye-game'); ?>
                    </button>
                </form>
            </div>
            
            <div class="dga-step dga-step-2" style="display: none;">
                <form class="dga-otp-form" method="post">
                    <input type="hidden" name="mobile" id="otp-mobile">
                    <input type="hidden" name="redirect" value="<?php echo esc_attr($atts['redirect']); ?>">
                    
                    <div class="form-group">
                        <label for="otp"><?php _e('Enter OTP Code:', 'donyaye-game'); ?></label>
                        <input type="text" id="otp" name="otp" placeholder="000000" maxlength="6" required>
                        <small class="dga-timer"><?php _e('Resend in:', 'donyaye-game'); ?> <span id="countdown">120</span>s</small>
                    </div>
                    
                    <button type="submit" class="dga-btn dga-btn-primary">
                        <?php _e('Verify OTP', 'donyaye-game'); ?>
                    </button>
                    
                    <button type="button" class="dga-btn dga-btn-secondary dga-back-btn">
                        <?php _e('Back', 'donyaye-game'); ?>
                    </button>
                </form>
            </div>
            
            <div class="dga-step dga-step-3" style="display: none;">
                <form class="dga-register-form" method="post">
                    <input type="hidden" name="mobile" id="reg-mobile">
                    <input type="hidden" name="redirect" value="<?php echo esc_attr($atts['redirect']); ?>">
                    
                    <div class="form-group">
                        <label for="first_name"><?php _e('First Name:', 'donyaye-game'); ?></label>
                        <input type="text" id="first_name" name="first_name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="last_name"><?php _e('Last Name:', 'donyaye-game'); ?></label>
                        <input type="text" id="last_name" name="last_name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="national_code"><?php _e('National Code:', 'donyaye-game'); ?></label>
                        <input type="text" id="national_code" name="national_code" maxlength="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="birth_date"><?php _e('Date of Birth:', 'donyaye-game'); ?></label>
                        <input type="date" id="birth_date" name="birth_date" required>
                    </div>
                    
                    <button type="submit" class="dga-btn dga-btn-primary">
                        <?php _e('Create Account', 'donyaye-game'); ?>
                    </button>
                </form>
            </div>
            
            <div class="dga-messages"></div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * User profile shortcode
     */
    public function user_profile_shortcode($atts) {
        if (!is_user_logged_in()) {
            return '<p>' . __('Please login to view your profile.', 'donyaye-game') . '</p>';
        }
        
        $user = wp_get_current_user();
        $mobile = get_user_meta($user->ID, 'mobile_number', true);
        $national_code = get_user_meta($user->ID, 'national_code', true);
        $birth_date = get_user_meta($user->ID, 'birth_date', true);
        $registration_date = get_user_meta($user->ID, 'registration_date', true);
        
        ob_start();
        ?>
        <div class="dga-user-profile">
            <h3><?php _e('User Profile', 'donyaye-game'); ?></h3>
            
            <div class="profile-info">
                <div class="info-row">
                    <label><?php _e('Name:', 'donyaye-game'); ?></label>
                    <span><?php echo esc_html($user->display_name); ?></span>
                </div>
                
                <div class="info-row">
                    <label><?php _e('Mobile:', 'donyaye-game'); ?></label>
                    <span><?php echo esc_html($mobile); ?></span>
                </div>
                
                <div class="info-row">
                    <label><?php _e('National Code:', 'donyaye-game'); ?></label>
                    <span><?php echo esc_html($national_code); ?></span>
                </div>
                
                <div class="info-row">
                    <label><?php _e('Date of Birth:', 'donyaye-game'); ?></label>
                    <span><?php echo esc_html($birth_date); ?></span>
                </div>
                
                <div class="info-row">
                    <label><?php _e('Registration Date:', 'donyaye-game'); ?></label>
                    <span><?php echo esc_html($registration_date); ?></span>
                </div>
            </div>
            
            <div class="profile-actions">
                <a href="<?php echo home_url('/dashboard'); ?>" class="dga-btn dga-btn-primary">
                    <?php _e('Go to Dashboard', 'donyaye-game'); ?>
                </a>
                <a href="<?php echo wp_logout_url(); ?>" class="dga-btn dga-btn-secondary">
                    <?php _e('Logout', 'donyaye-game'); ?>
                </a>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Get logged in user info
     */
    private function get_logged_in_user_info() {
        $user = wp_get_current_user();
        
        ob_start();
        ?>
        <div class="dga-logged-in">
            <p><?php printf(__('Welcome, %s!', 'donyaye-game'), esc_html($user->display_name)); ?></p>
            <div class="logged-in-actions">
                <a href="<?php echo home_url('/dashboard'); ?>" class="dga-btn dga-btn-primary">
                    <?php _e('Go to Dashboard', 'donyaye-game'); ?>
                </a>
                <a href="<?php echo wp_logout_url(); ?>" class="dga-btn dga-btn-secondary">
                    <?php _e('Logout', 'donyaye-game'); ?>
                </a>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Add modal forms to footer
     */
    public function add_modal_forms() {
        if (is_user_logged_in()) {
            return;
        }
        
        ?>
        <div id="dga-modal" class="dga-modal" style="display: none;">
            <div class="dga-modal-content">
                <span class="dga-close">&times;</span>
                <div id="dga-modal-body"></div>
            </div>
        </div>
        <?php
    }
    
    /**
     * Get form HTML for AJAX requests
     */
    public function get_form_html($form_type) {
        switch ($form_type) {
            case 'login':
                return $this->login_form_shortcode(array());
            case 'register':
                return $this->register_form_shortcode(array());
            default:
                return '';
        }
    }
} 