# DonyayeGame Plugin Languages

This directory contains language files for the DonyayeGame plugin.

## ⚠️ Important: Duplicate Translation Issue

**If you see errors about duplicate translations**, this means there are duplicate `msgid` entries in your `.po` file. This commonly happens when:

1. Copying translations from multiple sources
2. Merging language files incorrectly
3. Using translation tools that don't handle duplicates

### How to Fix Duplicates:

1. **Use the provided scripts** to compile languages
2. **Check for duplicate `msgid` entries** in your `.po` file
3. **Remove duplicate entries** keeping only one translation per string
4. **Recompile** the `.mo` file

### Quick Fix Commands:

**Linux/Mac:**
```bash
cd languages
chmod +x compile-languages.sh
./compile-languages.sh
```

**Windows:**
```cmd
cd languages
compile-languages.bat
```

## Available Languages

### Persian (Iran) - fa_IR
- **Source file**: `donyaye-game-fa_IR.po`
- **Compiled file**: `donyaye-game-fa_IR.mo`
- **RTL Support**: Yes (RTL CSS included)

## Adding New Languages

### 1. Create PO File
Create a new `.po` file with your language code:
```
donyaye-game-{language_code}.po
```

Example for Arabic:
```
donyaye-game-ar.po
```

### 2. Translate Strings
Use a PO editor like Poedit to translate all the strings in the PO file.

### 3. Compile MO File
Compile the PO file to create the `.mo` file:
```bash
msgfmt donyaye-game-{language_code}.po -o donyaye-game-{language_code}.mo
```

### 4. RTL Support (if needed)
For RTL languages (Arabic, Hebrew, etc.), create an RTL CSS file:
```
dga-main-{language_code}-rtl.css
```

### 5. Update Plugin
Add language detection in the main plugin file:
```php
// Load RTL styles for RTL languages
if (in_array(get_locale(), ['fa_IR', 'ar', 'he']) || is_rtl()) {
    wp_enqueue_style('dga-main-rtl', DGA_PLUGIN_URL . 'assets/css/dga-main-rtl.css', array('dga-main'), DGA_PLUGIN_VERSION);
}
```

## Language File Structure

### PO File Format
```po
msgid "English Text"
msgstr "Translated Text"
```

### Required Strings
The following strings must be translated:
- Login/Registration forms
- Dashboard sections
- Error messages
- Success messages
- Button labels
- Form labels
- Navigation items

## RTL Language Support

For RTL languages, the plugin automatically:
1. Loads RTL CSS when language is detected
2. Applies right-to-left layout
3. Adjusts sidebar positioning
4. Reverses form layouts
5. Adjusts text alignment

## Testing Translations

1. Change WordPress language in Settings → General
2. Clear cache if using caching plugins
3. Test all plugin functionality
4. Verify RTL layout (if applicable)

## Contributing

To contribute translations:
1. Fork the plugin repository
2. Create/update language files
3. Test thoroughly
4. Submit a pull request

## Support

For translation support, please contact the plugin developer or create an issue in the repository. 