@echo off
echo DonyayeGame Plugin - Language Compilation
echo ==========================================

REM Check if msgfmt is available
where msgfmt >nul 2>nul
if %errorlevel% neq 0 (
    echo Error: msgfmt command not found. Please install gettext tools.
    echo.
    echo You can download gettext for Windows from:
    echo https://mlocati.github.io/articles/gettext-iconv-windows.html
    echo.
    echo Or use online tools like:
    echo https://localise.biz/free/converter
    echo.
    pause
    exit /b 1
)

REM Compile Persian language
if exist "donyaye-game-fa_IR.po" (
    echo Compiling Persian (fa_IR)...
    msgfmt donyaye-game-fa_IR.po -o donyaye-game-fa_IR.mo
    if %errorlevel% equ 0 (
        echo ✓ Persian language compiled successfully!
    ) else (
        echo ✗ Error compiling Persian language
    )
) else (
    echo Warning: donyaye-game-fa_IR.po not found
)

REM Compile Arabic language
if exist "donyaye-game-ar.po" (
    echo Compiling Arabic (ar)...
    msgfmt donyaye-game-ar.po -o donyaye-game-ar.mo
    if %errorlevel% equ 0 (
        echo ✓ Arabic language compiled successfully!
    ) else (
        echo ✗ Error compiling Arabic language
    )
) else (
    echo Warning: donyaye-game-ar.po not found
)

echo.
echo Language compilation completed!
echo Make sure to upload both .po and .mo files to your server.
pause 