#!/bin/bash

# DonyayeGame Plugin Language Compilation Script
# This script compiles .po files to .mo files

echo "DonyayeGame Plugin - Language Compilation"
echo "=========================================="

# Check if msgfmt is available
if ! command -v msgfmt &> /dev/null; then
    echo "Error: msgfmt command not found. Please install gettext tools."
    echo "On Ubuntu/Debian: sudo apt-get install gettext"
    echo "On CentOS/RHEL: sudo yum install gettext"
    echo "On macOS: brew install gettext"
    exit 1
fi

# Compile Persian language
if [ -f "donyaye-game-fa_IR.po" ]; then
    echo "Compiling Persian (fa_IR)..."
    msgfmt donyaye-game-fa_IR.po -o donyaye-game-fa_IR.mo
    if [ $? -eq 0 ]; then
        echo "✓ Persian language compiled successfully!"
    else
        echo "✗ Error compiling Persian language"
    fi
else
    echo "Warning: donyaye-game-fa_IR.po not found"
fi

# Compile Arabic language
if [ -f "donyaye-game-ar.po" ]; then
    echo "Compiling Arabic (ar)..."
    msgfmt donyaye-game-ar.po -o donyaye-game-ar.mo
    if [ $? -eq 0 ]; then
        echo "✓ Arabic language compiled successfully!"
    else
        echo "✗ Error compiling Arabic language"
    fi
else
    echo "Warning: donyaye-game-ar.po not found"
fi

echo ""
echo "Language compilation completed!"
echo "Make sure to upload both .po and .mo files to your server." 